<?php
declare(strict_types=1);

namespace Opencart\Extension\StsnDevSeoUrlFix;

class StsnDevSeoUrlFixHelper
{
    protected \Opencart\System\Engine\Controller $controller;

    public const CODE = 'stsn_dev_seo_url_fix';
    public const TYPE = 'other';
    public const MIN_PHP_VERSION = '8.2.0';
    public const FILESYSTEM_PATH = 'extension/' . self::CODE . '/' . self::TYPE . '/';
    public const FULL_PATH        = self::FILESYSTEM_PATH . self::CODE;
    public const MODEL_ALIAS      = 'model_extension_' . self::CODE . '_' . self::TYPE . '_' . self::CODE;
    public const CONF_PREFIX      = self::TYPE . '_' . self::CODE;
    private ?string $secretKey = null;


    public function __construct(\Opencart\System\Engine\Controller $controller) {
        $this->controller = $controller;
    }

    /**
     * Получает значение настройки по ключу с префиксом расширения.
     *
     * @param string $key  Короткий ключ настройки (без префикса).
     *
     * @return mixed       Значение настройки (тип зависит от хранимого значения).
     */
    public function getExtConfigValue(string $key): mixed {
        return $this->controller->config->get(self::CONF_PREFIX . '_' . $key);
    }

    /**
     * Сохраняет значение настройки для указанного ключа и магазина.
     *
     * @param string $key       Короткий ключ настройки (будет дополнен префиксом).
     * @param mixed  $value     Значение настройки.
     * @param int    $store_id  ID магазина (по умолчанию 0).
     *
     * @return void
     */
    public function editExtConfigValue(string $key, mixed $value, int $store_id = 0): void {
        $full_key = self::CONF_PREFIX . '_' . $key;

        // проверяем наличие строки напрямую
        $query = $this->controller->db->query(
            "SELECT setting_id FROM `" . DB_PREFIX . "setting`
             WHERE `key` = '" . $this->controller->db->escape($full_key) . "'
               AND `store_id` = '" . (int)$store_id . "'
             LIMIT 1"
        );

        if (!$query->num_rows) {
            // если записи нет — создаём пустую
            $this->controller->db->query(
                "INSERT INTO `" . DB_PREFIX . "setting` SET
                    `store_id`  = '" . (int)$store_id . "',
                    `code`      = '" . $this->controller->db->escape(self::CONF_PREFIX) . "',
                    `key`       = '" . $this->controller->db->escape($full_key) . "',
                    `value`     = '',
                    `serialized`= 0"
            );
        }

        $this->controller->model_setting_setting->editValue(
            self::CONF_PREFIX,
            $full_key,
            $value,
            $store_id
        );
    }
}
