<?php
namespace Opencart\Catalog\Model\Extension\StsnDevSeoUrlFix\Other;
/**
 * Class SeoUrlFIx
 *
 * @package Opencart\Catalog\Model\Extension\StsnDevSeoUrlFix\Other
 */
class StsnDevSeoUrlFix extends \Opencart\System\Engine\Model
{

    public function getSeoUrlByKeyword(string $keyword): array {
        $query = $this->db->query("
        SELECT `key`, `value` 
        FROM `" . DB_PREFIX . "seo_url` 
        WHERE (`keyword` = '" . $this->db->escape($keyword) . "' 
            OR `keyword` LIKE '" . $this->db->escape('%/' . $keyword) . "') 
            AND `store_id` = '" . (int)$this->config->get('config_store_id') . "' 
        LIMIT 1
    ");

        return $query->row;
    }

    public function getSeoUrlsByKeyValue(string $conditionsStr): array {
        // Если строка условий пуста, возвращаем пустой результат
        if (empty($conditionsStr)) {
            return [];
        }

        // Удаляем лишние пробелы и запятые в конце строки условий
        $conditionsStr = rtrim($conditionsStr, ', ');

        // Выполняем запрос
        $query = $this->db->query("
        SELECT DISTINCT `key`, `value`, `keyword` , `sort_order`
        FROM `" . DB_PREFIX . "seo_url` 
        WHERE (`key`, `value`) IN (" . $conditionsStr . ") 
          AND `store_id` = '" . (int)$this->config->get('config_store_id') . "' 
          AND `language_id` = '" . (int)$this->config->get('config_language_id') . "'
    ");

        return $query->rows;
    }


    public function getBreadcrumbsKeyPass(string $object_id, string $object_type): string {
        if ($object_type === 'path') {
            return $this->getCategoryBreadcrumbsKeyPass($object_id);
        } elseif ($object_type === 'product_id') {
            return $this->getProductBreadcrumbsKeyPass($object_id);
        } elseif ($object_type === 'article_id') {
            return $this->getArticleTopicKeyPass($object_id);
        }
        return '';
    }

    private function getCategoryBreadcrumbsKeyPass(string $category_id): string {
        $breadcrumbs = [];

        // Получение иерархии категорий
        while ($category_id) {
            $breadcrumbs[] = $category_id;

            $query = $this->db->query("SELECT parent_id FROM " . DB_PREFIX . "category WHERE category_id = '" . (int)$category_id . "'");

            $category_id = $query->row['parent_id'] ?? null;
        }

        // Инвертируем порядок для правильной последовательности
        return implode('_', array_reverse($breadcrumbs));
    }

    private function getProductBreadcrumbsKeyPass(string $product_id): string {
        $categories = [];

        // Получаем категории, связанные с продуктом
        $query = $this->db->query("SELECT category_id FROM " . DB_PREFIX . "product_to_category WHERE product_id = '" . (int)$product_id . "'");

        foreach ($query->rows as $row) {
            $categories[$row['category_id']] = $this->getCategoryBreadcrumbsKeyPass($row['category_id']);
        }

        // Найти самую длинную цепочку категорий
        if (!empty($categories)) {
            return array_reduce($categories, function ($longest, $current) {
                return strlen($current) > strlen($longest) ? $current : $longest;
            }, '');
        }

        return '';
    }

    private function getArticleTopicKeyPass(string $article_id): string {
        // Получаем ID категории блога для статьи
        $query = $this->db->query("SELECT topic_id FROM " . DB_PREFIX . "article WHERE article_id = '" . (int)$article_id . "'");

        return $query->row['topic_id'];

    }

    public function editSettingsValue(string $code = '', string $key = '', $value = '', int $store_id = 0): void {
        $this->db->query("UPDATE `" . DB_PREFIX . "setting` SET `value` = '" . $this->db->escape(!is_array($value) ? $value : json_encode($value)) . "', `serialized` = '" . (bool)is_array($value) . "' WHERE `code` = '" . $this->db->escape($code) . "' AND `key` = '" . $this->db->escape($key) . "' AND `store_id` = '" . (int)$store_id . "'");
    }

}