<?php
namespace Opencart\Catalog\Controller\Extension\StsnDevSeoUrlFix\Startup;

require_once DIR_EXTENSION . 'stsn_dev_seo_url_fix/helper.php';
use Opencart\Extension\StsnDevSeoUrlFix\StsnDevSeoUrlFixHelper as ext;

class SeoUrl extends \Opencart\System\Engine\Controller {
    public function index(): void {
        $host = $this->request->server['HTTP_HOST'] ?? '';
        $phpOk = version_compare(PHP_VERSION, ext::MIN_PHP_VERSION, '>='); // минимальная версия PHP
        $ioncubeOk = extension_loaded('ionCube Loader'); // загружен ли ionCube

        if (($phpOk && $ioncubeOk) || str_contains($host, 'localhost')) {
            // Подключаем закодированный контроллер
            require_once DIR_EXTENSION . ext::CODE . '/catalog/controller/startup/SeoUrlCoded.php';

            // Создаём экземпляр закодированного класса и вызываем его index
            $coded = new \Opencart\Catalog\Controller\Extension\StsnDevSeoUrlFix\Startup\SeoUrlCoded($this->registry);
            $coded->index();
        }
    }
}
