<?php
namespace Opencart\Admin\Model\Extension\StsnDevSeoUrlFix\Other;

class StsnDevSeoUrlFix extends \Opencart\System\Engine\Model
{
    public function getExtensionInstallData(string $code = 'stsn_dev_seo_url_fix'): array
    {
        $code_esc = $this->db->escape($code);
        $query = $this->db->query("SELECT name, version, link, description FROM " . DB_PREFIX . "extension_install WHERE code = '" . $code_esc . "'");

        if ($query->num_rows) {
            return [
                'name' => $query->row['name'],
                'version' => $query->row['version'],
                'link' => $query->row['link'],
                'description' => $query->row['description']
            ];
        } else {
            return [
                'name' => 'undefined',
                'version' => 'undefined',
                'link' => 'undefined',
                'description' => 'undefined'
            ];
        }
    }

    public function setValue(string $code, string $key, $value, int $store_id = 0): void {
        // Приводим значение
        $serialized = is_array($value);
        $db_value = $this->db->escape($serialized ? json_encode($value) : $value);

        // Проверяем, существует ли уже запись
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "setting`
		WHERE `store_id` = '" . (int)$store_id . "'
		AND `code` = '" . $this->db->escape($code) . "'
		AND `key` = '" . $this->db->escape($key) . "'
		LIMIT 1");

        if ($query->num_rows) {
            // Обновляем
            $this->db->query("UPDATE `" . DB_PREFIX . "setting`
			SET `value` = '" . $db_value . "', `serialized` = '" . (int)$serialized . "'
			WHERE `store_id` = '" . (int)$store_id . "'
			AND `code` = '" . $this->db->escape($code) . "'
			AND `key` = '" . $this->db->escape($key) . "'");
        } else {
            // Вставляем
            $this->db->query("INSERT INTO `" . DB_PREFIX . "setting`
			SET `store_id` = '" . (int)$store_id . "',
			`code` = '" . $this->db->escape($code) . "',
			`key` = '" . $this->db->escape($key) . "',
			`value` = '" . $db_value . "',
			`serialized` = '" . (int)$serialized . "'");
        }
    }

    public function checkLangSeoRecords(int $store_id, string $language_code, int $required_number_of_keywords): string
    {
        $store_id_int = (int)$store_id;
        $language_code_esc = $this->db->escape($language_code);
        $table = DB_PREFIX . 'seo_url';

        $sql = trim(string: /** @lang SQL */ <<<SQL
            SELECT
                COUNT(*) AS total_records,
                COUNT(DISTINCT keyword) AS unique_keywords,
                MIN(keyword) AS single_keyword
            FROM `$table`
            WHERE `key` = 'language'
                  AND `store_id` = '$store_id_int'
                  AND `value` = '$language_code_esc'
                  AND keyword NOT IN (
                      SELECT keyword
                      FROM `$table`
                      WHERE `key` = 'language'
                        AND `store_id` = '$store_id_int'
                        AND `value` != '$language_code_esc'
                  )
        SQL);

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $total_records = (int)$query->row['total_records'];
            $unique_keywords = (int)$query->row['unique_keywords'];
            $single_keyword = $query->row['single_keyword'];

            if ($unique_keywords === 1 && $total_records === $required_number_of_keywords) {
                return $single_keyword;
            }
        }

        return '';
    }

    public function updateLangSeoUrls(array $languages_form_data)
    {
        $table = DB_PREFIX . 'seo_url';

        $query = $this->db->query("SELECT `language_id` FROM `" . DB_PREFIX . "language`");
        $language_ids_int = array_map('intval', array_column($query->rows, 'language_id'));
        $language_ids_str = implode(',', $language_ids_int);

        foreach ($languages_form_data as $store_id => $store_lang_form_data) {
            $store_id_int = (int)$store_id;

            // Обновление registered_languages — простой UPDATE
            if (!empty($store_lang_form_data['registered_languages'])) {
                foreach ($store_lang_form_data['registered_languages'] as $value => $keyword) {
                    $keyword_esc = $this->db->escape($keyword);
                    $value_esc = $this->db->escape($value);

                    $this->db->query(
                        trim(string: /** @lang SQL */ <<<SQL
                            UPDATE `$table`
                            SET `keyword` = '$keyword_esc'
                            WHERE `key` = 'language'
                              AND `value` = '$value_esc'
                              AND `store_id` = '$store_id_int'
                              AND `language_id` IN ($language_ids_str)
                        SQL)
                    );
                }
            }

            // Удаление conflict_or_not_registered_languages
            if (!empty($store_lang_form_data['conflict_or_not_registered_languages'])) {
                $values_to_delete_esc = array_map([$this->db, 'escape'], array_keys($store_lang_form_data['conflict_or_not_registered_languages']));
                $values_list = "'" . implode("','", $values_to_delete_esc) . "'";

                $sql_delete = trim(/** @lang text */ <<<SQL
                    DELETE FROM `$table`
                    WHERE `key` = 'language'
                      AND `store_id` = '$store_id_int'
                      AND `value` IN ($values_list)
                SQL);

                $this->db->query($sql_delete);

                // Вставка новых записей —
                foreach ($store_lang_form_data['conflict_or_not_registered_languages'] as $value => $keyword) {
                    $value_esc = $this->db->escape($value);
                    $keyword_esc = $this->db->escape($keyword);

                    foreach ($language_ids_int as $language_id_int) {
                        $check_sql = trim(string: /** @lang SQL */ <<<SQL
                            SELECT 1 FROM `$table`
                            WHERE `store_id` = '$store_id_int'
                              AND `language_id` = '$language_id_int'
                              AND `key` = 'language'
                              AND `value` = '$value_esc'
                              AND `keyword` = '$keyword_esc'
                              AND `sort_order` = '-2'
                        SQL);

                        $existing_query = $this->db->query($check_sql);

                        if (!$existing_query->num_rows) {
                            $insert_sql = trim(string: /** @lang SQL */<<<SQL
                                INSERT INTO `$table`
                                    (`store_id`, `language_id`, `key`, `value`, `keyword`, `sort_order`)
                                VALUES
                                    ('$store_id_int', '$language_id_int', 'language', '$value_esc', '$keyword_esc', '-2')
                            SQL);

                            $this->db->query($insert_sql);
                        }
                    }
                }
            }
        }
    }

    public function getKeywordByQuery($value, $store_id, $language_id): string {
        $query = $this->db->query(
            "SELECT keyword FROM `" . DB_PREFIX . "seo_url`
             WHERE `key` = 'route'
             AND `value` = '" . $this->db->escape($value) . "'
             AND `store_id` = '" . (int)$store_id . "'
             AND `language_id` = '" . (int)$language_id . "'
             LIMIT 1"
        );

        return $query->num_rows ? $query->row['keyword'] : '';
    }

    public function saveMainControllersSeoUrls(string $route, int $store_id, int $language_id, string $keyword): void {
        // Сначала проверим, есть ли запись с таким route/store/language
        $query = $this->db->query("
        SELECT seo_url_id FROM `" . DB_PREFIX . "seo_url`
        WHERE `key` = 'route'
        AND `value` = '" . $this->db->escape($route) . "'
        AND `store_id` = '" . (int)$store_id . "'
        AND `language_id` = '" . (int)$language_id . "'
        LIMIT 1
    ");

        if ($query->num_rows) {
            $seo_url_id = (int)$query->row['seo_url_id'];

            if ($keyword === '') {
                // Если keyword пустой — удаляем запись
                $this->db->query("DELETE FROM `" . DB_PREFIX . "seo_url` WHERE seo_url_id = '" . $seo_url_id . "'");
            } else {
                // Обновляем keyword
                $this->db->query("
                UPDATE `" . DB_PREFIX . "seo_url`
                SET `keyword` = '" . $this->db->escape($keyword) . "'
                WHERE seo_url_id = '" . $seo_url_id . "'
            ");
            }
        } else {
            // Если запись отсутствует и keyword не пустой — вставляем новую
            if ($keyword !== '') {
                $this->db->query("
                INSERT INTO `" . DB_PREFIX . "seo_url`
                SET
                    `store_id` = '" . (int)$store_id . "',
                    `language_id` = '" . (int)$language_id . "',
                    `key` = 'route',
                    `value` = '" . $this->db->escape($route) . "',
                    `keyword` = '" . $this->db->escape($keyword) . "',
                    `sort_order` = 0
            ");
            }
        }
    }

    public function getRouteByKeyword($lang_id, $store_id, $keyword) {
        $sql = "SELECT `value` 
            FROM `" . DB_PREFIX . "seo_url`
            WHERE `key` = 'route'
              AND `language_id` = '" . (int)$lang_id . "'
              AND `store_id` = '" . (int)$store_id . "'
              AND `keyword` = '" . $this->db->escape($keyword) . "'
            LIMIT 1";

        $query = $this->db->query($sql);
        return $query->row ?: null; // вернёт ['value' => 'controller/name'] или null
    }


}
