<?php
namespace Opencart\Admin\Model\Extension\StsnDevAdminPlus\Other;

class StsnDevAdminPlus extends \Opencart\System\Engine\Model
{
    public function getExtensionInstallData(string $code = 'stsn_dev_seo_url_fix'): array
    {
        $code_esc = $this->db->escape($code);
        $query = $this->db->query("SELECT name, version, link, description FROM " . DB_PREFIX . "extension_install WHERE code = '" . $code_esc . "'");

        if ($query->num_rows) {
            return [
                'name' => $query->row['name'],
                'version' => $query->row['version'],
                'link' => $query->row['link'],
                'description' => $query->row['description']
            ];
        } else {
            return [
                'name' => 'undefined',
                'version' => 'undefined',
                'link' => 'undefined',
                'description' => 'undefined'
            ];
        }
    }

    public function setValue(string $code, string $key, $value, int $store_id = 0): void {
        // Приводим значение
        $serialized = is_array($value);
        $db_value = $this->db->escape($serialized ? json_encode($value) : $value);

        // Проверяем, существует ли уже запись
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "setting`
		WHERE `store_id` = '" . (int)$store_id . "'
		AND `code` = '" . $this->db->escape($code) . "'
		AND `key` = '" . $this->db->escape($key) . "'
		LIMIT 1");

        if ($query->num_rows) {
            // Обновляем
            $this->db->query("UPDATE `" . DB_PREFIX . "setting`
			SET `value` = '" . $db_value . "', `serialized` = '" . (int)$serialized . "'
			WHERE `store_id` = '" . (int)$store_id . "'
			AND `code` = '" . $this->db->escape($code) . "'
			AND `key` = '" . $this->db->escape($key) . "'");
        } else {
            // Вставляем
            $this->db->query("INSERT INTO `" . DB_PREFIX . "setting`
			SET `store_id` = '" . (int)$store_id . "',
			`code` = '" . $this->db->escape($code) . "',
			`key` = '" . $this->db->escape($key) . "',
			`value` = '" . $db_value . "',
			`serialized` = '" . (int)$serialized . "'");
        }
    }

}
