<?php
namespace Opencart\Admin\Controller\Extension\StsnDevAdminPlus;

require_once DIR_EXTENSION . 'stsn_dev_admin_plus/helper.php';
use Opencart\Extension\StsnDevAdminPlus\StsnDevHelper as ext;

class AdminEventActions extends \Opencart\System\Engine\Controller {
    private $coded = null;

    private function getCodedInstance() {
        if ($this->coded === null) {
            $host     = $this->request->server['HTTP_HOST'] ?? '';
            $phpOk    = version_compare(PHP_VERSION, ext::MIN_PHP_VERSION, '>=');
            $ioncubeOk = extension_loaded('ionCube Loader');

            if (($phpOk && $ioncubeOk) || str_contains($host, 'localhost')) {
                require_once DIR_EXTENSION . ext::CODE . '/admin/controller/AdminEventActionsCoded.php';
                $this->coded = new \Opencart\Admin\Controller\Extension\StsnDevAdminPlus\AdminEventActionsCoded($this->registry);
            }
        }

        return $this->coded;
    }

    public function view_event_before(string &$route, array &$args): void {
        $coded = $this->getCodedInstance();
        if ($coded && method_exists($coded, __FUNCTION__)) {
            $coded->{__FUNCTION__}($route, $args);
        }
    }

    public function view_event_after(string &$route, array &$args, &$output): void {
        $coded = $this->getCodedInstance();
        if ($coded && method_exists($coded, __FUNCTION__)) {
            $coded->{__FUNCTION__}($route, $args, $output);
        }
    }
}
